const passport = require('passport');
const bcrypt = require('bcrypt');          // ← imported but NEVER USED!
const LocalStrategy = require('passport-local').Strategy;

function initialize(passportInstance, getUserByName, getUserById) {
  // Authentication logic for login
  const authenticateUser = async (username, password, done) => {
    const user = getUserByName(username);

    if (user == null) {
      return done(null, false, { message: "Wrong Password !" });
    }

    try {
      if (password === user.password) {
        return done(null, user);
      } else {
        return done(null, false, { message: "Wrong Password !" });
      }
    } catch (error) {
      return done(error);
    }
  };

  passportInstance.use(
    new LocalStrategy(
      { usernameField: "name" },
      authenticateUser
    )
  );

  passportInstance.serializeUser((user, done) => {
    done(null, user.id);
  });

  passportInstance.deserializeUser((id, done) => {
    const user = getUserById(id);
    done(null, user);
  });
}

module.exports = initialize;